package com.ht.bo;

import java.io.Serializable;
import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;

import com.ht.vo.Cart;
import com.ht.vo.Product;

@ManagedBean(name="cart")
@RequestScoped
public class CartBean implements Serializable{

	 
	private Cart myCart;
	public CartBean() {
		super();
		setMyCart(getMyShoppingCart());
	}
	
	private double totalAmount;
	
	
	public double getTotalAmount() {
		return totalCalcAmount();
	}

	public void setTotalAmount(double totalAmount) {
		this.totalAmount = totalAmount;
	}

	private Cart getMyShoppingCart(){
		HttpSession session = (HttpSession) FacesContext.getCurrentInstance().getExternalContext().getSession(false);
		return ((Cart)session.getAttribute("mycart"));
	}

	public Cart getMyCart() {
		return myCart;
	}


	public void setMyCart(Cart myCart) {
		this.myCart = myCart;
	}


	public List<Product> getCartList() {
		return myCart.getProdList();
	}
	
public String saveAction() {
		
		for (Product order : getCartList()){
			if(order.getQty() > 0) {
			 System.out.println(order.getProductID() + "-- " + order.getQty() + "------>" );
		 	 
	 		}
	 	 
		}
		
		KanglaEbookBO bo = new KanglaEbookBO();
		bo.createOrder(getCartList(), getMyShoppingCart().getCartID(), myCart.getDeliveryInstruction());
 	    System.out.println("I Order" + myCart.getDeliveryInstruction() + getCartList());
 		return null;
		
	}

  private double totalCalcAmount(){
	  double totalAMount = 0.0;
	  for (Product order : getMyShoppingCart().getProdList()){
			totalAMount += order.getPrice()*order.getQty();
		}
	  return totalAMount;
  }
}
